#!/bin/sh

MASTER_PAGE_NEW_ESXI_MS_IMAGE_PATH_SELECT_RESULT_MSG=""
MASTER_PAGE_NEW_ESXI_MS_IMAGE_PATH_SELECT_RESULT_OK=0
MASTER_PAGE_NEW_ESXI_MS_IMAGE_PATH_SELECT_RESULT_ERROR=1

MASTER_PAGE_NEW_ESXI_MS_IMAGE_PATH_SELECT_RESULT_CODE=${MASTER_PAGE_NEW_ESXI_MS_IMAGE_PATH_SELECT_RESULT_ERROR}
MASTER_PAGE_NEW_ESXI_MS_IMAGE_PATH_SELECT_RESULT_ROLLING=0

master_page_new_esxi_ms_image_path_select() {
	debug_print "in function '${FUNCNAME[0]}'"
	
	# following 3 esxi infos, $new_esxi_host_ip, $new_esxi_username, $new_esxi_password
	# defined from master_page_add_esxi.sh, 
	# queried from master_page_new_esxi_info_conf.sh
	
    tp_esxi_image_select \
        "${MASTER_PAGE_NEW_ESXI_MS_IMAGE_PATH_SELECT_TITLE}" \
        "${MASTER_PAGE_NEW_ESXI_MS_IMAGE_PATH_SELECT_TEXT}" \
        "${MASTER_PAGE_NEW_ESXI_MS_IMAGE_PATH_SELECT_LABEL_OK}" \
        "${MASTER_PAGE_NEW_ESXI_MS_IMAGE_PATH_SELECT_LABEL_CANCEL}" \
        "${new_esxi_host_ip}" \
        "${new_esxi_username}" \
        "${new_esxi_password}" \
        "${conf_ms_prefix}"
	
	debug_print "TP_ESXI_IMAGE_SELECT_RESULT_CODE: ${TP_ESXI_IMAGE_SELECT_RESULT_CODE}"
    case "${TP_ESXI_IMAGE_SELECT_RESULT_CODE}" in
    
        "${TP_ESXI_IMAGE_SELECT_RESULT_ERROR}" )
			debug_print "${TP_ESXI_IMAGE_SELECT_RESULT_MSG}"
			MASTER_PAGE_NEW_ESXI_MS_IMAGE_PATH_SELECT_RESULT_CODE=$MASTER_PAGE_NEW_ESXI_MS_IMAGE_PATH_SELECT_RESULT_ERROR
            MASTER_PAGE_NEW_ESXI_MS_IMAGE_PATH_SELECT_RESULT_ROLLING=-1
			if [ "${TP_ESXI_IMAGE_SELECT_RESULT_MSG}" == "${TP_ESXI_IMAGE_SELECT_ERROR_DATASTORE_IS_NOT_FOUND}" ]; then
				MASTER_PAGE_NEW_ESXI_MS_IMAGE_PATH_SELECT_RESULT_MSG=$ERROR_ESXI_CANNOT_GET_IMAGE_PATH_DATASTORE
			else
				MASTER_PAGE_NEW_ESXI_MS_IMAGE_PATH_SELECT_RESULT_MSG=$ERROR_ESXI_CANNOT_GET_IMAGE_PATH_MS
			fi
            return
            ;;
        
        "${TP_ESXI_IMAGE_SELECT_RESULT_CANCEL}" )
			MASTER_PAGE_NEW_ESXI_MS_IMAGE_PATH_SELECT_RESULT_CODE=$MASTER_PAGE_NEW_ESXI_MS_IMAGE_PATH_SELECT_RESULT_OK
            MASTER_PAGE_NEW_ESXI_MS_IMAGE_PATH_SELECT_RESULT_ROLLING=-1
            MASTER_PAGE_NEW_ESXI_MS_IMAGE_PATH_SELECT_RESULT_MSG=""
            return
            ;;
            
        "${TP_ESXI_IMAGE_SELECT_RESULT_CTRLC}" )
			MASTER_PAGE_NEW_ESXI_MS_IMAGE_PATH_SELECT_RESULT_CODE=$MASTER_PAGE_NEW_ESXI_MS_IMAGE_PATH_SELECT_RESULT_OK
            MASTER_PAGE_NEW_ESXI_MS_IMAGE_PATH_SELECT_RESULT_ROLLING=0
            MASTER_PAGE_NEW_ESXI_MS_IMAGE_PATH_SELECT_RESULT_MSG=""
            return
            ;;
            
        "${TP_ESXI_IMAGE_SELECT_RESULT_OK}" )
            ;;
            
        * )
			
			MASTER_PAGE_NEW_ESXI_MS_IMAGE_PATH_SELECT_RESULT_CODE=$MASTER_PAGE_NEW_ESXI_MS_IMAGE_PATH_SELECT_RESULT_ERROR
            MASTER_PAGE_NEW_ESXI_MS_IMAGE_PATH_SELECT_RESULT_ROLLING=0
            MASTER_PAGE_NEW_ESXI_MS_IMAGE_PATH_SELECT_RESULT_MSG="${MASTER_PAGE_NEW_ESXI_MS_IMAGE_PATH_SELECT_ERROR_UNKNOWN}"
            return
            ;;
    esac

	# defined from master_page_add_esxi.sh, used by master_page_new_esxi_save_conf.sh
	new_esxi_ms_real_image_path=${TP_ESXI_IMAGE_SELECT_RESULT_IMAGE_PATH}
	debug_print "ClusterMsImagePath='${new_esxi_ms_real_image_path}'"

	debug_print "CheckClusterAvailability..."
    local msg
	msg=`php "${CONS_BACKEND}" check_new_esxi_sb_structure \
            "${new_esxi_host_ip}" \
            "${new_esxi_username}" \
            "${new_esxi_password}" \
            "${new_esxi_ms_real_image_path}"`
    local ret="${?}"
    
    if [ "${ret}" -ne 0 ]; then
        
        # ClusterNotSwitchable
        if [ "${ret}" -eq 1 ]; then
            debug_print "CheckClusterAvailabilityFail: ret='${ret}', msg='ClusterNotSwitchable'"

        # ClusterSbGroupInconsistent
        elif [ "${ret}" -eq 2 ]; then
            debug_print "CheckClusterAvailabilityFail: ret='${ret}', msg='ClusterSbGroupInconsistent'"

        # ClusterNatSettingInconsistent
        elif [ "${ret}" -eq 3 ]; then
            debug_print "CheckClusterAvailabilityFail: ret='${ret}', msg='ClusterNatSettingInconsistent'"
            
        # unknown error
        else
            debug_print "CheckClusterAvailabilityFail: ret='${ret}', msg='${msg}'"
        fi
        
        # query management server image count
        msg=`php "${CONS_BACKEND}" list_all_esxi_vmx_file \
                    "${new_esxi_host_ip}" \
                    "${new_esxi_username}" \
                    "${new_esxi_password}" \
                    "ManagementServer"`
        ret="${?}"
        if [ "${ret}" -ne 0 ]; then
            debug_print "QueryManagementServerImageCountFail: ret='${ret}', msg='${msg}'"
            
            MASTER_PAGE_NEW_ESXI_MS_IMAGE_PATH_SELECT_RESULT_CODE="${MASTER_PAGE_NEW_ESXI_MS_IMAGE_PATH_SELECT_RESULT_ERROR}"
            MASTER_PAGE_NEW_ESXI_MS_IMAGE_PATH_SELECT_RESULT_ROLLING=-1
            MASTER_PAGE_NEW_ESXI_MS_IMAGE_PATH_SELECT_RESULT_MSG="${msg}"
            return
        fi
        local msImageCount=`echo "${msg}" | wc -l`

        MASTER_PAGE_NEW_ESXI_MS_IMAGE_PATH_SELECT_RESULT_CODE="${MASTER_PAGE_NEW_ESXI_MS_IMAGE_PATH_SELECT_RESULT_ERROR}"        
        [ "${msImageCount}" -eq 1 ] && \
            MASTER_PAGE_NEW_ESXI_MS_IMAGE_PATH_SELECT_RESULT_ROLLING=-1 || \
            MASTER_PAGE_NEW_ESXI_MS_IMAGE_PATH_SELECT_RESULT_ROLLING=0
        MASTER_PAGE_NEW_ESXI_MS_IMAGE_PATH_SELECT_RESULT_MSG="${MASTER_PAGE_NEW_ESXI_MS_IMAGE_PATH_SELECT_INVALID_SLAVE_STATUS}"
        return
    fi
    
    debug_print "CheckClusterAvailabilityPass: ret='${ret}'"
    MASTER_PAGE_NEW_ESXI_MS_IMAGE_PATH_SELECT_RESULT_CODE=$MASTER_PAGE_ESXI_INFO_CONF_RESULT_OK
    MASTER_PAGE_NEW_ESXI_MS_IMAGE_PATH_SELECT_RESULT_ROLLING=1
    MASTER_PAGE_NEW_ESXI_MS_IMAGE_PATH_SELECT_RESULT_MSG=""
}
